// 8EchoServer.cpp: implementation of the C8EchoServer class.
//
//////////////////////////////////////////////////////////////////////

#include	"stdafx.h"

#include	"8EchoServer.h"
#include	"8Callback.h"
#include	"8Connection.h"
#include	"8PKPool.h"

#include	"misc.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

C8EchoServer::C8EchoServer()
{
	m_hStopEvent = NULL;
}

C8EchoServer::~C8EchoServer()
{
	if( m_hStopEvent)
		CloseHandle( m_hStopEvent );
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Start()
{
	SOCKET			listener;
	WSADATA			wsaData;

	SOCKADDR_IN		addr;
					addr.sin_family			= AF_INET;
					addr.sin_addr.s_addr	= INADDR_ANY;
					addr.sin_port			= htons( (short)SERVER_PORT );

	int				idx = 0;

	C8Connection*	pConnection = NULL;
	C8PKPool*		pPKPool = NULL;

	unsigned int	dummy;
	int				maxthreads;
	HANDLE*			pThread = NULL;
	HANDLE			hIOCP = NULL;

    SYSTEM_INFO si;
    GetSystemInfo( &si );

    maxthreads = (int) si.dwNumberOfProcessors * 2;

	// initialize socket library
	if( SOCKET_ERROR == WSAStartup(0x202,&wsaData) )
		goto errors;

	// create listen socket
	if( INVALID_SOCKET == (listener=socket(AF_INET,SOCK_STREAM,0)) )
		goto errors;

	// bind listen socket
	if( 0 != bind(listener,(SOCKADDR *)&addr,sizeof(addr)) )
		goto errors;

	// listening for an incoming connection
	if( 0 != listen(listener,5) )
		goto errors;

	// create memory pool for ovl structure and packet buffer
	if( 0 == (pPKPool = new C8PKPool) )
		goto errors;
	//
//	if( 0 == pPKPool->Create("c:\\echopacket.log") )
	if( 0 == pPKPool->Create() )
		goto errors;

	// create IOCP
	if( NULL == (hIOCP=CreateIoCompletionPort(INVALID_HANDLE_VALUE,0,0,0)) )
		goto errors;

	// create threads
	if( 0 == (pThread = new HANDLE[maxthreads]) )
		goto errors;

	for( idx = 0; idx < maxthreads; idx++ )
	{
		if( 0 == (pThread[idx]=(HANDLE)_beginthreadex(0,0,
			IoCompletionCallback,hIOCP,0,&dummy)) )
			goto errors;
	}

	// create connection
	if( 0 == (pConnection = new C8Connection[MAXUSER]) )
		goto errors;

	// initialize connectino
	for( idx = 0; idx < MAXUSER; idx++ )
		if( 0 == pConnection[idx].Create(idx+1,hIOCP,listener,pPKPool) )
			goto errors;

#if 0
	// create a multishot timer that begins firing after 15 second.
	// non-I/O component, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION 
	if( 0 == CreateTimerQueueTimer(&hTimerQTimer,NULL,
		CheckConnectionCallback,pConnection,TIMELIMIT,TIMELIMIT,0) )
		goto errors;
#endif

	// connect listener socket to IOCP
	if( 0 == CreateIoCompletionPort((HANDLE)listener,hIOCP,0,0) )
		goto errors;

	// create event for stop thread pool
	if( NULL == (m_hStopEvent=CreateEvent(0,TRUE,FALSE,0)) )
		goto errors;


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
	char	szDate[32],
			szTime[32];

	_tzset();
	_strdate( szDate );
	_strtime( szTime );

	printf( "%s %s initialized at %s, %s\n",
		SERVER_NAME, SERVER_VERSION, szDate, szTime );

	// wait for stop event signal, ־ ⼭ ·..
	WaitForSingleObject( m_hStopEvent, INFINITE );
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

	// queue suicide packets
	for( idx = 0; idx < maxthreads; idx++ )
	{
		if( 0 == PostQueuedCompletionStatus(hIOCP,0,
			IOCP_SHUTDOWN,0) )
			goto errors;
	}

	// wait for thread terminations
	idx = WaitForMultipleObjects( maxthreads, &pThread[0], TRUE, 15000 );
	switch ( idx )
	{
	case WAIT_TIMEOUT:
		printf( "Not all threads died in time.\n" );
		break;
	case WAIT_FAILED:
		printf( "WAIT_FAILED, WaitForMultipleObjects()\n" );
		break;
	default:
		break;
	}

errors:
	// close thread handle
	if( pThread )
	{
		for( idx = 0; idx < maxthreads; idx++ )
			CloseHandle( pThread[idx] );
		delete [] pThread;
	}

	// close stop event
	if( m_hStopEvent )
	{
		CloseHandle( m_hStopEvent );
		m_hStopEvent = NULL;
	}

	// close all User socket
	if( pConnection )
	{
		printf( "shutdown user context..\n" );
//		for( idx = 0; idx < MAXUSER; idx++ )
//			pConnection[idx].Shutdown( NULL, TRUE );
		delete [] pConnection;
	}

	// shutdown packet pool
	if( pPKPool )
	{
		printf( "shutdown packet pool..\n" );
		delete pPKPool;
	}

	// close socket
	if( listener != INVALID_SOCKET )
	{
		struct linger li = {1, 0};	// Default: SO_DONTLINGER
		shutdown( listener, SD_BOTH );
		setsockopt( listener, SOL_SOCKET, SO_LINGER, (char *)&li, sizeof(li) );
		closesocket( listener );
		listener = INVALID_SOCKET;
	}

	// close IOCP
	if( hIOCP )
		CloseHandle( hIOCP );

	//
	WSACleanup();

	printf( "shutdown sequence finished..\n\npress any key." );

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Stop()
{
	SetEvent( m_hStopEvent );

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Restart()
{
	return TRUE;
}
